/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8281;

import ibm.nways.jdm.DestinationPropBook;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.NotSupported;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.eui.JDMWizardInfo;
import ibm.nways.jdm.eui.JDMWizardPanelDelegate;
import ibm.nways.jdm.eui.MessageBox;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.ras.RAS;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;

public class RingNumFilterCreate
implements JDMWizardPanelDelegate {
    private static ResourceBundle myResources = ResourceBundle.getBundle("ibm.nways.jdm8281.Resources");
    private static int MaxRows = 10;
    private static final int RASID = 19;
    private static final int RASSUB = 12;
    DestinationPropBook myBook;
    JdmBrowser browser;
    GenModel device_Model;
    NavigationContext myContext;
    MessageBox messageToUser;
    GenModel model;
    String errorMsg;
    boolean noErrors = true;

    public void setDefaults(JDMWizardInfo jDMWizardInfo) {
        try {
            int n;
            this.model = jDMWizardInfo.getModel();
            Vector vector = this.model.getRestOfInfo("Panel", "default", null, null);
            if (RAS.isEnabled(19, 12)) {
                RAS.trace(19, 12, this, "setDefaults", "###  rows.size() = " + vector.size());
            }
            if ((n = vector.size() + 1) >= MaxRows) {
                if (RAS.isEnabled(19, 12)) {
                    RAS.trace(19, 12, this, "setDefaults", "DL: Create - Table Full");
                }
                this.errorMsg = new String("WZ_TableFull");
                this.noErrors = false;
                return;
            }
        }
        catch (Exception exception) {
            if (RAS.isEnabled(19, 12)) {
                RAS.trace(19, 12, this, "proceed", "DL: Table Create - can't get model/info to get nextFreeIndex for row creation");
            }
            RAS.logException(19, 12, this, "setDefaults", exception);
            this.errorMsg = new String("WZ_getError");
            this.noErrors = false;
        }
    }

    public boolean abort(JDMWizardInfo jDMWizardInfo) {
        return true;
    }

    public boolean proceed(JDMWizardInfo jDMWizardInfo) {
        ModelInfo modelInfo = null;
        int n = 0;
        Hashtable hashtable = null;
        this.noErrors = true;
        if (RAS.isEnabled(19, 12)) {
            RAS.trace(19, 12, this, "proceed", "proceed");
        }
        long l = System.currentTimeMillis();
        this.myBook = (DestinationPropBook)jDMWizardInfo.getPropertyBook();
        if (this.browser == null && this.myBook != null) {
            this.browser = (JdmBrowser)this.myBook.getBrowser();
        }
        if (this.browser == null) {
            if (RAS.isEnabled(19, 12)) {
                RAS.trace(19, 12, this, "proceed", "8281: No browser available");
            }
            this.noErrors = false;
        }
        if (this.noErrors) {
            if (this.device_Model == null) {
                this.device_Model = (GenModel)this.browser.getModel();
            }
            try {
                Object object;
                Object object2;
                this.model = jDMWizardInfo.getModel();
                Vector vector = this.model.getRestOfInfo("Panel", "default", null, null);
                n = 1;
                hashtable = jDMWizardInfo.getItems();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    modelInfo = (ModelInfo)enumeration.nextElement();
                    Serializable serializable = modelInfo.get("Index.AtmBrUsrFilterInRingNumberIndex");
                    object2 = modelInfo.get("Index.AtmBrUsrFilterInRingNumberPort");
                    object = hashtable.get("newAtmBrUsrFilterInRingNumberPort");
                    if (!(object2 instanceof Integer) || !(serializable instanceof Integer)) continue;
                    int n2 = (Integer)object2;
                    int n3 = (Integer)object;
                    if (RAS.isEnabled(19, 12)) {
                        RAS.trace(19, 12, this, "proceed", "thisport = " + n2 + "userPort = " + n3);
                    }
                    if (n2 != n3) continue;
                    ++n;
                }
                if (RAS.isEnabled(19, 12)) {
                    RAS.trace(19, 12, this, "proceed", "###  rows.size() = " + vector.size());
                }
                if (vector.size() >= MaxRows) {
                    if (RAS.isEnabled(19, 12)) {
                        RAS.trace(19, 12, this, "proceed", "DL: Create - Table Full");
                    }
                    this.errorMsg = new String("WZ_TableFull");
                    this.noErrors = false;
                }
                int n4 = 1;
                object2 = vector.elements();
                while (object2.hasMoreElements()) {
                    Serializable serializable;
                    modelInfo = (ModelInfo)object2.nextElement();
                    object = modelInfo.get("Index.AtmBrUsrFilterInRingNumberIndex");
                    Serializable serializable2 = modelInfo.get("Index.AtmBrUsrFilterInRingNumberPort");
                    Object v = hashtable.get("newAtmBrUsrFilterInRingNumberPort");
                    if (RAS.isEnabled(19, 12)) {
                        RAS.trace(19, 12, this, "proceed", "LOOP");
                    }
                    if (serializable2 instanceof Integer && object instanceof Integer) {
                        int n5 = (Integer)serializable2;
                        int n6 = (Integer)v;
                        if (RAS.isEnabled(19, 12)) {
                            RAS.trace(19, 12, this, "proceed", "thisport = " + n5 + "userPort = " + n6);
                            RAS.trace(19, 12, this, "proceed", "###  Index = " + object);
                        }
                        if (n5 != n6) continue;
                        if ((Integer)object > n4) {
                            if (RAS.isEnabled(19, 12)) {
                                RAS.trace(19, 12, this, "proceed", "Found open slot");
                            }
                            n = n4;
                            break;
                        }
                    }
                    if ((serializable = modelInfo.get("Panel.AtmBrUsrFilterInRingNumberIndex")) instanceof NotSupported) {
                        n = n4;
                        break;
                    }
                    ++n4;
                }
            }
            catch (Exception exception) {
                if (RAS.isEnabled(19, 12)) {
                    RAS.trace(19, 12, this, "proceed", "DL: Table Create - can't get model/info to get nextFreeIndex for row creation");
                }
                RAS.logException(19, 12, this, "proceed", exception);
                this.errorMsg = new String("WZ_getError");
                this.noErrors = false;
            }
        }
        if (this.noErrors) {
            if (RAS.isEnabled(19, 12)) {
                RAS.trace(19, 12, this, "proceed", "### Creating row  " + n);
            }
            this.model = jDMWizardInfo.getModel();
            modelInfo = new ModelInfo();
            hashtable = jDMWizardInfo.getItems();
            modelInfo.add("Index.AtmBrUsrFilterInRingNumberPort", (Serializable)hashtable.get("newAtmBrUsrFilterInRingNumberPort"));
            modelInfo.add("Index.AtmBrUsrFilterInRingNumberIndex", new Integer(n));
            modelInfo.add("Panel.AtmBrUsrFilterInRingNumber", (Serializable)hashtable.get("newAtmBrUsrFilterInRingNumber"));
            modelInfo.add("Panel.AtmBrUsrFilterInRingNumberMask", (Serializable)hashtable.get("newAtmBrUsrFilterInRingNumberMask"));
            modelInfo.add("Panel.AtmBrUsrFilterInRingNumberActions", new Integer(2));
            modelInfo.add("Panel.AtmBrUsrFilterInRingNumPermitDeny", (Serializable)hashtable.get("newPermitDeny"));
            modelInfo.add("Panel.AtmBrUsrFilterInRingNumFrameType", (Serializable)hashtable.get("newFrameType"));
            try {
                modelInfo = this.model.setInfo("Panel", modelInfo);
                this.noErrors = this.checkSnmpResponse(modelInfo);
                if (!this.noErrors) {
                    this.errorMsg = new String("WZ_badSet");
                }
            }
            catch (Exception exception) {
                this.noErrors = false;
                this.errorMsg = new String("WZ_badSet");
                if (RAS.isEnabled(19, 12)) {
                    RAS.trace(19, 12, this, "proceed", "DL: Exception creating row of table");
                }
                RAS.logException(19, 12, this, "proceed", exception);
            }
        }
        if (!this.noErrors && this.browser != null) {
            this.browser.displayMsg(RingNumFilterCreate.getNLSString(this.errorMsg));
            this.messageToUser = new MessageBox(this.browser.getFrame(), RingNumFilterCreate.getNLSString("TC_error"), RingNumFilterCreate.getNLSString(this.errorMsg), true);
        }
        long l2 = System.currentTimeMillis();
        if (RAS.isEnabled(19, 12)) {
            RAS.trace(19, 12, this, "proceed", " Finished proceed() " + String.valueOf(l2 - l) + " msecs");
        }
        return this.noErrors;
    }

    protected static String getNLSString(String string) {
        String string2 = null;
        try {
            string2 = myResources.getString(string);
        }
        catch (Exception exception) {
            string2 = string;
        }
        return string2;
    }

    private boolean checkSnmpResponse(ModelInfo modelInfo) {
        boolean bl = false;
        Enumeration enumeration = modelInfo.getItemIds();
        while (enumeration.hasMoreElements()) {
            bl = true;
            String string = (String)enumeration.nextElement();
            Serializable serializable = modelInfo.get(string);
            if (!(serializable instanceof SpecialValue)) continue;
            if (RAS.isEnabled(19, 12)) {
                RAS.trace(19, 12, this, "checkSnmpResponse", "DL: Error in snmp set. Variable is " + string + "  SpecialValue is " + serializable);
            }
            bl = false;
            break;
        }
        return bl;
    }
}

